# APNs Push Notification untuk iOS

Implementasi sederhana untuk mengirim push notification ke aplikasi iOS menggunakan APNs (Apple Push Notification service).

## Instalasi

1. Install dependencies:
```bash
composer install
```

2. Siapkan file `.p8` dari Apple Developer Console:
   - Buka [Apple Developer Console](https://developer.apple.com/account/)
   - Buat APNs key baru
   - Download file `.p8`
   - Simpan di folder ini dengan nama `AuthKey.p8`

## Konfigurasi

Edit file `simple_example.php` dan ganti data berikut:

```php
$teamId = 'YOUR_TEAM_ID';           // Apple Team ID
$keyId = 'YOUR_KEY_ID';             // Key ID dari .p8 file  
$privateKeyPath = 'AuthKey.p8';     // File .p8
$bundleId = 'com.yourcompany.app';  // Bundle ID aplikasi
$isProduction = false;              // false = sandbox, true = production

$deviceToken = 'DEVICE_TOKEN_DARI_APLIKASI_IOS'; // Token dari app iOS
```

## Cara Pakai

1. **Kirim notifikasi sederhana:**
```bash
php simple_example.php
```

2. **Contoh lengkap:**
```bash
php examples/send_notification.php
php examples/send_multiple_notifications.php
php examples/send_custom_payload.php
```

## Struktur File

```
notif/
├── src/
│   └── APNSPushNotification.php    # Class utama
├── config/
│   └── apns.php                    # Konfigurasi
├── examples/                        # Contoh penggunaan
├── simple_example.php              # Contoh sederhana
├── composer.json                   # Dependencies
└── README.md                       # Dokumentasi ini
```

## Catatan Penting

- **Development**: Gunakan `isProduction = false` (sandbox)
- **Production**: Gunakan `isProduction = true` (App Store)
- **Bundle ID**: Harus sama dengan yang ada di aplikasi iOS
- **Device Token**: Dapatkan dari aplikasi iOS menggunakan `expo-notifications`

## Troubleshooting

- **"Private key file tidak ditemukan"**: Pastikan file `.p8` ada di folder yang benar
- **"Koneksi gagal"**: Periksa Team ID, Key ID, dan file `.p8`
- **"Gagal mengirim notifikasi"**: Periksa device token dan bundle ID
