<?php

// Pastikan sudah install dependencies dengan: composer install
require_once 'vendor/autoload.php';

use Notif\APNSPushNotification;

// Load konfigurasi dari file config
$config = require __DIR__ . '/config/apns.php';

// Konfigurasi APNs - Ganti dengan data Anda
$teamId = $config['team_id'];                    // Apple Team ID
$keyId = $config['key_id'];                      // Key ID dari .p8 file
$privateKeyPath = $config['private_key_path'];   // File .p8 dari config
$bundleId = $config['bundle_id'];                // Bundle ID aplikasi
$isProduction = $config['is_production'];        // false = sandbox, true = production

// Device token dari aplikasi iOS (ganti dengan token yang sebenarnya)
$deviceToken = '453a30624f438c31e7819b670916018ae7d392bfc42ff9d62c0dff3fceb9c156';

try {
    // Buat instance APNs
    $apns = new APNSPushNotification($teamId, $keyId, $privateKeyPath, $bundleId, $isProduction);
    
    echo "=== Test Koneksi ===\n";
    $test = $apns->testConnection();
    if ($test['success']) {
        echo "✅ Koneksi berhasil\n\n";
    } else {
        echo "❌ Koneksi gagal: " . $test['message'] . "\n";
        exit;
    }
    
    echo "=== Kirim Notifikasi ===\n";
    
    // Kirim notifikasi sederhana
    $result = $apns->sendNotification(
        $deviceToken,                    // Device token
        'Halo! 👋',                     // Judul notifikasi
        'Ini adalah pesan test dari PHP' // Isi notifikasi
    );
    
    if ($result['success']) {
        echo "✅ Notifikasi berhasil dikirim!\n";
    } else {
        echo "❌ Gagal mengirim notifikasi\n";
        echo "Error: " . $result['error'] . "\n";
        echo "HTTP Code: " . $result['http_code'] . "\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
